
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("Keyboard_Production")

# Create decision variables
x = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x") # 61-key keyboards
y = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="y") # 81-key keyboards

# Set objective function
model.setObjective(1500*x + 2500*y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(8*x + 16*y <= 3000, "chip_constraint")
model.addConstr(1.5*x + 1.5*y <= 8, "time_constraint")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Revenue: ${model.objVal}")
    print(f"Number of 61-key keyboards: {x.x}")
    print(f"Number of 81-key keyboards: {y.x}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

