
from gurobipy import *

# Create a model
m = Model("Keyboard_Production")

# Define the decision variables
x61 = m.addVar(vtype=GRB.INTEGER, name="x61")
x81 = m.addVar(vtype=GRB.INTEGER, name="x81")

# Set the objective function
m.setObjective(1500*x61 + 2500*x81, GRB.MAXIMIZE)

# Add constraints
m.addConstr(8*x61 + 16*x81 <= 3000, "chip_constraint")
m.addConstr(x61 + x81 <= 16/3, "time_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print("x61 =", x61.x)
    print("x81 =", x81.x)
    print("Objective function value:", m.objVal)
else:
    print("No optimal solution found")
