
import gurobi

def solve_keyboard_production():
    # Create a new model
    model = gurobi.Model()

    # Decision variables
    x1 = model.addVar(lb=0, name="61_key_keyboard")
    x2 = model.addVar(lb=0, name="81_key_keyboard")

    # Objective function: Maximize total revenue
    model.setObjective(1500*x1 + 2500*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(8*x1 + 16*x2 <= 3000, name="oscillator_chips")
    model.addConstr(1.5*x1 + 1.5*x2 <= 480, name="production_time")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal production quantities:")
        print(f"61-key keyboards: {x1.varValue}")
        print(f"81-key keyboards: {x2.varValue}")
        print(f"Max Revenue: {model.objVal}")
    else:
        print("The problem is infeasible")

solve_keyboard_production()
