
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("HotelRoomOptimization")

# Create decision variables
r = model.addVar(lb=0, vtype=GRB.INTEGER, name="regular_rooms")
p = model.addVar(lb=0, vtype=GRB.INTEGER, name="premium_rooms")

# Set objective function
model.setObjective(100*r + 500*p, GRB.MAXIMIZE)

# Add constraints
model.addConstr(r + p <= 500, "total_rooms")
model.addConstr(r >= 100, "min_regular")
model.addConstr(p >= 2*r, "premium_preference")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Regular Rooms: {r.x}")
    print(f"Premium Rooms: {p.x}")
    print(f"Total Profit: ${model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution found.")
else:
    print(f"Optimization terminated with status: {model.status}")

