
from gurobipy import *

# Create a model
m = Model("Hotel_Room_Optimization")

# Define variables
R = m.addVar(vtype=GRB.INTEGER, name="Regular_Rooms")
P = m.addVar(vtype=GRB.INTEGER, name="Premium_Rooms")

# Constraints
m.addConstr(R + P <= 500, "Total_Rooms")
m.addConstr(R >= 100, "Minimum_Regular_Rooms")
m.addConstr(P >= 2 * R, "Preference_Constraint")

# Objective function
m.setObjective(100 * R + 500 * P, GRB.MAXIMIZE)

# Solve the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Regular Rooms: {R.x}")
    print(f"Premium Rooms: {P.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")

