
import gurobi

def solve_hotel_room_optimization():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    R = model.addVar(lb=0, name="Regular_Rooms")
    P = model.addVar(lb=0, name="Premium_Rooms")

    # Objective function: Maximize profit
    model.setObjective(100*R + 500*P, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(R + P <= 500, name="Total_Rooms")
    model.addConstr(R >= 100, name="Min_Regular_Rooms")
    model.addConstr(P >= 2*R, name="Premium_vs_Regular")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution:")
        print(f"Regular Rooms: {R.varValue}")
        print(f"Premium Rooms: {P.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_hotel_room_optimization()
