
import gurobipy as gp

# Create a new model
model = gp.Model("BikeShop")

# Create decision variables
x = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="mountain_bikes") # Integer number of mountain bikes
y = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="road_bikes") # Integer number of road bikes


# Set objective function
model.setObjective(300*x + 500*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(x + y <= 150, "demand")
model.addConstr(750*x + 1000*y <= 40000, "budget")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of mountain bikes: {x.x}")
    print(f"Number of road bikes: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

