
from gurobipy import *

# Create a model
m = Model("Bike_Stocking")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="Mountain_Bikes")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="Road_Bikes")

# Set the objective function
m.setObjective(300*x1 + 500*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 150, "Total_Bikes")
m.addConstr(750*x1 + 1000*x2 <= 40000, "Total_Cost")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Mountain Bikes: {x1.x}")
    print(f"Road Bikes: {x2.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")
