
import gurobi

def bike_shop_optimization():
    # Create a new model
    model = gurobi.Model()

    # Define decision variables
    M = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="Mountain_Bikes")
    R = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="Road_Bikes")

    # Objective function: Maximize profit
    model.setObjective(300*M + 500*R, gurobi.GRB.MAXIMIZE)

    # Demand constraint
    model.addConstr(M + R <= 150, name="Demand_Constraint")

    # Inventory value constraint
    model.addConstr(750*M + 1000*R <= 40000, name="Inventory_Value_Constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found. Mountain Bikes: {M.varValue}, Road Bikes: {R.varValue}")
    else:
        print("No optimal solution found.")

if __name__ == "__main__":
    bike_shop_optimization()
