
from gurobipy import Model, GRB

# Create a new model
m = Model("Potato Transportation")

# Create variables
x = m.addVar(vtype=GRB.INTEGER, name="regular_trucks")  # Integer since truck trips are whole numbers
y = m.addVar(vtype=GRB.INTEGER, name="refrigerated_trucks")

# Set objective function
m.setObjective(70*x + 100*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(50*x + 70*y <= 5000, "budget_constraint")
m.addConstr(y <= x, "refrigerated_truck_limit")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal number of packages: {m.objVal}")
    print(f"Number of regular truck trips: {x.x}")
    print(f"Number of refrigerated truck trips: {y.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

