
from gurobipy import *

# Create a new model
m = Model("Potato_Transport")

# Define variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="regular_truck_trips")
y = m.addVar(vtype=GRB.CONTINUOUS, name="refrigerated_truck_trips")

# Set the objective function: maximize the total number of packages transported
m.setObjective(70*x + 100*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(50*x + 70*y <= 5000, "cost_limit")
m.addConstr(y <= x, "refrigerated_truck_limit")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of regular truck trips: {x.x}")
    print(f"Number of refrigerated truck trips: {y.x}")
    print(f"Total packages transported: {70*x.x + 100*y.x}")
else:
    print("No optimal solution found")
