
import gurobi

def solve_potato_transportation_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    R = model.addVar(lb=0, name="Regular_Truck_Trips", vtype=gurobi.GRB.CONTINUOUS)
    r = model.addVar(lb=0, name="Refrigerated_Truck_Trips", vtype=gurobi.GRB.CONTINUOUS)

    # Objective function: Maximize 70R + 100r
    model.setObjective(70*R + 100*r, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(50*R + 70*r <= 5000, name="Cost_Constraint")
    model.addConstr(r <= R, name="Refrigerated_vs_Regular_Trips")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution: Regular Truck Trips = {R.varValue}, Refrigerated Truck Trips = {r.varValue}")
        print(f"Maximum Packages Transported: {70*R.varValue + 100*r.varValue}")
    else:
        print("The model is infeasible or unbounded.")

solve_potato_transportation_problem()
