
import gurobipy as gp

# Create a new model
model = gp.Model("InstrumentProduction")

# Create decision variables
v = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="violins")
h = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="harps")

# Set objective function
model.setObjective(200 * v + 350 * h, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(6 * v + 2 * h <= 100, "woodworking")
model.addConstr(2.5 * v + 10 * h <= 150, "assembling")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of violins to produce: {v.x}")
    print(f"Number of harps to produce: {h.x}")
    print(f"Maximum profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

