
from gurobipy import *

# Create a model
m = Model("Instrument_Production")

# Define the decision variables
V = m.addVar(lb=0, vtype=GRB.INTEGER, name="Violins")
H = m.addVar(lb=0, vtype=GRB.INTEGER, name="Harps")

# Define the objective function
m.setObjective(200*V + 350*H, GRB.MAXIMIZE)

# Add constraints
m.addConstr(6*V + 2*H <= 100, "Woodworking_Time")
m.addConstr(2.5*V + 10*H <= 150, "Assembling_Time")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Violins: {V.x}")
    print(f"Harps: {H.x}")
    print(f"Total Profit: ${200*V.x + 350*H.x}")
else:
    print("No optimal solution found.")
