
import gurobi

def solve_factory_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the decision variables
    v = model.addVar(lb=0, name="violins")
    h = model.addVar(lb=0, name="harps")

    # Define the objective function
    model.setObjective(200 * v + 350 * h, gurobi.GRB.MAXIMIZE)

    # Add the woodworking time constraint
    model.addConstr(6 * v + 2 * h <= 100, name="woodworking_time")

    # Add the assembling time constraint
    model.addConstr(2.5 * v + 10 * h <= 150, name="assembling_time")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution:")
        print(f"Violins: {v.varValue}")
        print(f"Harp: {h.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found")

solve_factory_problem()
