
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Tropical_Crops")

# Create variables
x = m.addVar(lb=0, name="coconut_acres") # Acres of coconut trees
y = m.addVar(lb=0, name="banana_acres")  # Acres of banana trees

# Set objective function
m.setObjective(400*x + 350*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 200, "land_constraint")
m.addConstr(200*x + 150*y <= 15000, "budget_constraint")
m.addConstr(5*x + 4*y <= 750, "labor_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Plant {x.x:.2f} acres of coconut trees")
    print(f"Plant {y.x:.2f} acres of banana trees")
    print(f"Maximum Profit: ${m.objVal:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible. No solution exists.")
else:
    print(f"Optimization terminated with status {m.status}")

