
from gurobipy import *

# Create a new model
m = Model("George's Tree Planting")

# Define variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="coconut_acres", lb=0)
y = m.addVar(vtype=GRB.CONTINUOUS, name="banana_acres", lb=0)

# Objective function: Maximize profit
m.setObjective(400*x + 350*y, GRB.MAXIMIZE)

# Constraint 1: Budget constraint
m.addConstr(200*x + 150*y <= 15000, "budget")

# Constraint 2: Labor constraint
m.addConstr(5*x + 4*y <= 750, "labor")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal acres of coconut trees: {x.x}")
    print(f"Optimal acres of banana trees: {y.x}")
    print(f"Maximum profit: ${400*x.x + 350*y.x:.2f}")
else:
    print("No optimal solution found")
