
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    C = model.addVar(lb=0, name="Coconut_Trees")  # Acres of coconut trees
    B = model.addVar(lb=0, name="Banana_Trees")  # Acres of banana trees

    # Objective function: Maximize profit
    model.setObjective(400*C + 350*B, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(C + B <= 200, name="Land_Constraint")
    model.addConstr(200*C + 150*B <= 15000, name="Budget_Constraint")
    model.addConstr(5*C + 4*B <= 750, name="Labor_Constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal acres of coconut trees: {C.varValue}")
        print(f"Optimal acres of banana trees: {B.varValue}")
        print(f"Maximal profit: {model.objVal}")
    else:
        print("The problem is infeasible")

solve_optimization_problem()
