
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("desk_chair_production")

# Create decision variables
x = model.addVar(lb=0, vtype=GRB.INTEGER, name="standing_desks") # Integer number of desks
y = model.addVar(lb=0, vtype=GRB.INTEGER, name="office_chairs") # Integer number of chairs

# Set objective function
model.setObjective(500*x + 230*y, GRB.MINIMIZE)

# Add constraints
model.addConstr(60*x + 35*y >= 2000, "machine_time")
model.addConstr(x + y >= 100, "min_production")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of standing desks: {x.x}")
    print(f"Number of office chairs: {y.x}")
    print(f"Minimum Cost: ${model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution exists.")
else:
    print(f"Optimization terminated with status: {model.status}")

