
from gurobipy import *

# Create a new model
m = Model("Factory_Optimization")

# Define the decision variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="standing_desks")
y = m.addVar(vtype=GRB.CONTINUOUS, name="office_chairs")

# Set the objective function to minimize costs
m.setObjective(500*x + 230*y, GRB.MINIMIZE)

# Add constraints: minimum operation time and total items
m.addConstr(60*x + 35*y >= 2000, "minimum_operation_time")
m.addConstr(x + y >= 100, "total_items")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Standing Desks: {x.x}")
    print(f"Office Chairs: {y.x}")
    print(f"Total Cost: ${500*x.x + 230*y.x:.2f}")
else:
    print("No optimal solution found")

