
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(name="standing_desks", lb=0, vtype=gurobi.GRB.INTEGER)
    y = model.addVar(name="office_chairs", lb=0, vtype=gurobi.GRB.INTEGER)

    # Objective function: Minimize cost
    model.setObjective(500*x + 230*y, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(60*x + 35*y >= 2000, name="machine_time")
    model.addConstr(x + y >= 100, name="min_production")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution: standing desks = {x.varValue}, office chairs = {y.varValue}")
        print(f"Minimum Cost: ${model.objVal:.2f}")
    else:
        print("The model is infeasible.")

solve_optimization_problem()
