
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("weight_loss_program")

# Create variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="indian_plates")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="thai_plates")

# Set objective function
m.setObjective(12*x + 15*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(13*x + 8*y >= 200, "protein_req")
m.addConstr(23*x + 12*y >= 50, "carb_req")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal cost: ${m.objVal:.2f}")
    print(f"Indian plates: {x.x:.2f}")
    print(f"Thai plates: {y.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

