
from gurobipy import *

# Create a new model
m = Model("WeightLossProgram")

# Define variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="IndianFood", lb=0)
y = m.addVar(vtype=GRB.CONTINUOUS, name="ThaiFood", lb=0)

# Set the objective function: minimize cost
m.setObjective(12*x + 15*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(13*x + 8*y >= 200, "ProteinRequirement")
m.addConstr(23*x + 12*y >= 50, "CarbRequirement")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Indian Food Plates: {x.x}")
    print(f"Thai Food Plates: {y.x}")
    print(f"Total Cost: ${12*x.x + 15*y.x:.2f}")
else:
    print("No optimal solution found")
