
import gurobi

def solve_weight_loss_program():
    # Create a new model
    model = gurobi.Model()

    # Define decision variables
    x = model.addVar(name="Indian_food", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    y = model.addVar(name="Thai_food", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Objective function: minimize cost
    model.setObjective(12*x + 15*y, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(13*x + 8*y >= 200, name="protein_requirement")
    model.addConstr(23*x + 12*y >= 50, name="carb_requirement")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Indian food: {x.varValue} plates")
        print(f"Thai food: {y.varValue} plates")
        print(f"Minimum cost: ${model.objVal:.2f}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("No feasible solution exists.")
    else:
        print("Optimization failed.")

solve_weight_loss_program()
