
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("backpack_handbag")

# Create variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="backpacks") # Number of backpacks
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="handbags") # Number of handbags

# Set objective function
m.setObjective(5*x + 8*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(20*x + 15*y >= 3000, "machine_time")
m.addConstr(x + y >= 180, "total_items")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of backpacks: {x.x}")
    print(f"Number of handbags: {y.x}")
    print(f"Minimum Cost: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

