
from gurobipy import *

# Create a model
m = Model("Backpack_Handbag_Optimization")

# Define decision variables
B = m.addVar(vtype=GRB.CONTINUOUS, name="Backpacks", lb=0)
H = m.addVar(vtype=GRB.CONTINUOUS, name="Handbags", lb=0)

# Define the objective function
m.setObjective(5*B + 8*H, GRB.MINIMIZE)

# Add constraints
m.addConstr(20*B + 15*H >= 3000, "Machine_Minutes")
m.addConstr(B + H >= 180, "Total_Items")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Backpacks: {B.x}")
    print(f"Handbags: {H.x}")
    print(f"Total Cost: {m.objVal}")
else:
    print("No optimal solution found")
