
import gurobi

def solve_production_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    B = model.addVar(lb=0, name="Backpacks")
    H = model.addVar(lb=0, name="Handbags")

    # Objective function: Minimize production cost
    model.setObjective(5 * B + 8 * H, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(20 * B + 15 * H >= 3000, name="Machine_Time")
    model.addConstr(B + H >= 180, name="Minimum_Production")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution: Backpacks = {B.varValue}, Handbags = {H.varValue}")
    else:
        print("The model is infeasible.")

solve_production_problem()
