
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Flower_Profit")

# Create variables
x = m.addVar(nonneg=True, name="tulips") # Acres of tulips
y = m.addVar(nonneg=True, name="daffodils") # Acres of daffodils

# Set objective function
m.setObjective(325*x + 200*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 200, "land_constraint")
m.addConstr(10*x + 5*y <= 1500, "budget_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Plant {x.x:.2f} acres of tulips")
    print(f"Plant {y.x:.2f} acres of daffodils")
    print(f"Maximum Profit: ${m.objVal:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

