
from gurobipy import *

# Create a new model
m = Model("Tulips_and_Daffodils")

# Define the variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="tulips")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="daffodils")

# Set the objective function (maximize profit)
m.setObjective(325*x + 200*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*x + 5*y <= 1500, "budget")
m.addConstr(x + y <= 200, "land")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: Grow {x.x:.2f} acres of tulips and {y.x:.2f} acres of daffodils.")
else:
    print("No optimal solution found.")

