
import gurobi as gp
from gurobi import GRB

# Create a new model
model = gp.Model("Tulips_and_Daffodils")

# Define the variables
T = model.addVar(0, 200, name="Tulips_acres")  # Acres for tulips
D = model.addVar(0, 200, name="Daffodils_acres")  # Acres for daffodils

# Objective function: Maximize profit
model.setObjective(325 * T + 200 * D, GRB.MAXIMIZE)

# Constraints
model.addConstr(T + D <= 200, name="Total_acres")  # Total acres constraint
model.addConstr(10 * T + 5 * D <= 1500, name="Budget_constraint")  # Budget constraint

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print(f"Optimal acres for tulips: {T.varValue}")
    print(f"Optimal acres for daffodils: {D.varValue}")
    print(f"Maximal profit: ${325 * T.varValue + 200 * D.varValue}")
else:
    print("The model is infeasible")
