
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("sandwich_optimization")

# Create decision variables
x = m.addVar(vtype=GRB.INTEGER, name="egg_sandwiches") # Number of egg sandwiches
y = m.addVar(vtype=GRB.INTEGER, name="ham_sandwiches") # Number of ham sandwiches


# Set objective function
m.setObjective(3.5*x + 5*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x + y <= 50, "egg_constraint")
m.addConstr(2*x + 4*y <= 60, "ham_constraint")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of egg sandwiches: {x.x}")
    print(f"Number of ham sandwiches: {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution found.")
else:
    print(f"Optimization terminated with status: {m.status}")

