
from gurobipy import *

# Create a new model
m = Model("FoodTruck")

# Define variables
x = m.addVar(vtype=GRB.INTEGER, name="EggSandwiches")
y = m.addVar(vtype=GRB.INTEGER, name="HamSandwiches")

# Set the objective function: Maximize profit
m.setObjective(3.5*x + 5*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x + y <= 50, "EggAvailability")
m.addConstr(2*x + 4*y <= 60, "HamAvailability")

# Non-negativity constraints (can't make a negative number of sandwiches)
m.addConstr(x >= 0, "NonNegEggSandwiches")
m.addConstr(y >= 0, "NonNegHamSandwiches")

# Optimize the model
m.optimize()

# Print out the results
for v in m.getVars():
    print('%s %g' % (v.varName, v.x))
