
import gurobi

def solve_sandwich_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the decision variables
    x1 = model.addVar(lb=0, name="egg_sandwiches")
    x2 = model.addVar(lb=0, name="ham_sandwiches")

    # Define the objective function
    model.setObjective(3.5 * x1 + 5 * x2, gurobi.GRB.MAXIMIZE)

    # Add the eggs constraint
    model.addConstr(5 * x1 + x2 <= 50, name="eggs_constraint")

    # Add the ham constraint
    model.addConstr(2 * x1 + 4 * x2 <= 60, name="ham_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Egg sandwiches: {x1.varValue}")
        print(f"Ham sandwiches: {x2.varValue}")
        print(f"Max profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_sandwich_problem()
