
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("pizza_optimization")

# Create decision variables
x = m.addVar(lb=0, vtype=GRB.INTEGER, name="pepperoni_pizzas")
y = m.addVar(lb=0, vtype=GRB.INTEGER, name="hawaiian_pizzas")

# Set objective function
m.setObjective(4*x + 5*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x >= 35, "pepperoni_min")
m.addConstr(x <= 40, "pepperoni_max")
m.addConstr(y >= 40, "hawaiian_min")
m.addConstr(y <= 70, "hawaiian_max")
m.addConstr(x + y <= 90, "total_sales")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of pepperoni pizzas: {x.x}")
    print(f"Number of hawaiian pizzas: {y.x}")
    print(f"Maximum profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution found.")
else:
    print(f"Optimization terminated with status: {m.status}")

