
from gurobipy import *

# Create a new model
m = Model("Pizza_Shop_Profit")

# Define variables
x = m.addVar(name='pepperoni_pizzas', vtype=GRB.INTEGER, lb=35, ub=40)
y = m.addVar(name='hawaiian_pizzas', vtype=GRB.INTEGER, lb=40, ub=70)

# Objective function: Maximize profit
m.setObjective(4*x + 5*y, GRB.MAXIMIZE)

# Constraint: Total pizzas sold cannot exceed 90
m.addConstr(x + y <= 90, name='total_pizzas')

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print('Optimal solution found:')
    print(f'Sell {x.x} pepperoni pizzas')
    print(f'Sell {y.x} Hawaiian pizzas')
    print(f'Total profit: ${4*x.x + 5*y.x}')
else:
    print('No optimal solution found')

# Print model
m.write("pizza_shop_model.lp")
