
import gurobi as gp
from gurobi import GRB

# Create a new model
model = gp.Model("pizza_shop")

# Define variables
P = model.addVar(lb=35, ub=40, name="pepperoni_pizzas", vtype=GRB.INTEGER)
H = model.addVar(lb=40, ub=70, name="hawaiian_pizzas", vtype=GRB.INTEGER)

# Objective function: Maximize profit
model.setObjective(4 * P + 5 * H, GRB.MAXIMIZE)

# Constraint: Total pizzas cannot exceed 90
model.addConstr(P + H <= 90, name="total_pizzas")

# Solve the model
model.optimize()

# Check if the model is optimized
if model.status == GRB.OPTIMAL:
    print(f"Optimal solution found.")
    print(f"Pepperoni pizzas to sell: {P.varValue}")
    print(f"Hawaiian pizzas to sell: {H.varValue}")
    print(f"Max Profit: ${4 * P.varValue + 5 * H.varValue}")
else:
    print("No optimal solution found.")
