
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("shed_treehouse_production")

    # Create variables
    x = m.addVar(vtype=gp.GRB.CONTINUOUS, name="sheds")
    y = m.addVar(vtype=gp.GRB.CONTINUOUS, name="treehouses")


    # Set objective function
    m.setObjective(700*x + 500*y, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(4*x + 2*y <= 40, "building_time")
    m.addConstr(2*x + 1.5*y <= 30, "painting_time")
    m.addConstr(x >= 0, "sheds_nonnegative")  # Explicit non-negativity constraints
    m.addConstr(y >= 0, "treehouses_nonnegative")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print(f"Optimal Solution Found:")
        print(f"Number of sheds to build: {x.x}")
        print(f"Number of treehouses to build: {y.x}")
        print(f"Maximum profit: ${m.objVal}")
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization terminated with status {m.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
