
from gurobipy import *

# Create a new model
m = Model("Sheds_and_Treehouses")

# Define the decision variables
S = m.addVar(vtype=GRB.INTEGER, name="sheds")
T = m.addVar(vtype=GRB.INTEGER, name="treehouses")

# Define the constraints
m.addConstr(4*S + 2*T <= 40, "building_time_constraint")
m.addConstr(2*S + 1.5*T <= 30, "painting_time_constraint")
m.addConstr(S >= 0, "non_negativity_sheds")
m.addConstr(T >= 0, "non_negativity_treehouses")

# Define the objective function
m.setObjective(700*S + 500*T, GRB.MAXIMIZE)

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Sheds: {S.x}")
    print(f"Treehouses: {T.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")
