
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    S = model.addVar(lb=0, name="Sheds")
    T = model.addVar(lb=0, name="Treehouses")

    # Define the objective function
    model.setObjective(700*S + 500*T, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(4*S + 2*T <= 40, name="Building_Time")
    model.addConstr(2*S + 1.5*T <= 30, name="Painting_Time")

    # Optimize the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.Status.OPTIMAL:
        # Get the optimized values
        sheds = S.varValue
        treehouses = T.varValue
        max_profit = model.objVal

        print(f"Optimal solution: Build {sheds} sheds and {treehouses} treehouses.")
        print(f"Maximum profit: ${max_profit:.2f}")
    else:
        print("The model is infeasible.")

# Run the optimization problem
solve_optimization_problem()
