
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("linda_bakery")

# Create variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="chocolate_chip")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="oatmeal")

# Set objective
m.setObjective(4 * x + 3 * y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(10 * x + 20 * y <= 360, "mixing_time")
m.addConstr(x + 2 * y <= 50, "vanilla")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Revenue: ${m.objVal}")
    print(f"Chocolate Chip Cookies: {x.x}")
    print(f"Oatmeal Cookies: {y.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

