
from gurobipy import *

# Create a new model
m = Model("Bakery_Problem")

# Define the decision variables
x1 = m.addVar(lb=0, name="chocolate_chip_cookies")
x2 = m.addVar(lb=0, name="oatmeal_cookies")

# Define the objective function: Maximize revenue
m.setObjective(4*x1 + 3*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*x1 + 20*x2 <= 360, name="mixing_time_constraint")
m.addConstr(x1 + 2*x2 <= 50, name="vanilla_extract_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of chocolate chip cookies: {x1.x}")
    print(f"Number of oatmeal cookies: {x2.x}")
    print(f"Maximum revenue: ${4*x1.x + 3*x2.x:.2f}")
else:
    print("No optimal solution found.")
