
import gurobipy as gp

# Create a new model
model = gp.Model("Linda_Bakery")

# Define the decision variables
x = model.addVar(name="chocolate_chip_cookies", lb=0)
y = model.addVar(name="oatmeal_cookies", lb=0)

# Objective function: Maximize revenue
model.setObjective(4*x + 3*y, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(10*x + 20*y <= 360, name="mixing_time")
model.addConstr(x + 2*y <= 50, name="vanilla_extract")

# Solve the model
model.solve()

# Output the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Chocolate Chip Cookies: {x.varValue}")
    print(f"Oatmeal Cookies: {y.varValue}")
    print(f"Max Revenue: {model.objVal}")
else:
    print("The model is infeasible.")
