
import gurobipy as gp

# Create a new model
m = gp.Model("scarf_toque_production")

# Create variables
scarves = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="scarves")
toques = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="toques")

# Set objective function
m.setObjective(20 * scarves + 25 * toques, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(20 * scarves + 30 * toques <= 250000, "time_constraint")
m.addConstr(scarves >= 5000, "scarf_demand")
m.addConstr(toques >= 3000, "toque_demand")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of scarves to produce: {scarves.x}")
    print(f"Number of toques to produce: {toques.x}")
    print(f"Maximum profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

