
from gurobipy import *

# Create a model
m = Model("Knitting_Factory")

# Define decision variables
S = m.addVar(vtype=GRB.INTEGER, name="Scarfs")
T = m.addVar(vtype=GRB.INTEGER, name="Toques")

# Objective function: Maximize profit
m.setObjective(20*S + 25*T, GRB.MAXIMIZE)

# Constraints
m.addConstr(20*S + 30*T <= 250000, "Time_Constraint")
m.addConstr(S >= 5000, "Min_Scarfs")
m.addConstr(T >= 3000, "Min_Toques")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Scarfs: {S.x}")
    print(f"Toques: {T.x}")
    print(f"Maximum Profit: ${20*S.x + 25*T.x}")
else:
    print("No optimal solution found")
