
import gurobipy as gp

# Create a new model
m = gp.Model("scarfs_toques")

# Variables
S = m.addVar(lb=5000, name="scarfs")  # At least 5000 scarfs
T = m.addVar(lb=3000, name="toques")  # At least 3000 toques

# Objective function: Maximize profit
m.setObjective(20*S + 25*T, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(20*S + 30*T <= 250000, name="knitting_time")

# Solve the model
m.solve()

# Output the solution
if m.status == gp.GRB.Status.OPTIMAL:
    print(f"Optimal Solution: Scarfs = {S.varValue}, Toques = {T.varValue}")
    print(f"Max Profit: ${20*S.varValue + 25*T.varValue}")
else:
    print("No optimal solution found.")
