
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("CoatProduction")

# Create variables
N = m.addVar(lb=0, name="NorthFactoryHours")
S = m.addVar(lb=0, name="SouthFactoryHours")

# Set objective function
m.setObjective(200*N + 400*S, GRB.MINIMIZE)

# Add constraints
m.addConstr(20*N + 30*S >= 75, "LongCoatDemand")
m.addConstr(15*N + 25*S >= 30, "ShortCoatDemand")
m.addConstr(10*N + 30*S >= 40, "MiniCoatDemand")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Cost: ${m.objVal}")
    print(f"North Factory Hours: {N.x}")
    print(f"South Factory Hours: {S.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

