
from gurobipy import *

# Create a new model
m = Model("Tom Designs Production Plan")

# Define the decision variables
x_n = m.addVar(name='north_factory_hours', vtype=GRB.CONTINUOUS, lb=0)
x_s = m.addVar(name='south_factory_hours', vtype=GRB.CONTINUOUS, lb=0)

# Define the objective function: minimize total cost
m.setObjective(200*x_n + 400*x_s, GRB.MINIMIZE)

# Add constraints based on production requirements
m.addConstr(20*x_n + 30*x_s >= 75, name='long_coats_requirement')
m.addConstr(15*x_n + 25*x_s >= 30, name='short_coats_requirement')
m.addConstr(10*x_n + 30*x_s >= 40, name='mini_coats_requirement')

# Optimize the model
m.optimize()

# Print out the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"North Factory Hours: {x_n.x}")
    print(f"South Factory Hours: {x_s.x}")
    print(f"Total Cost: ${200*x_n.x + 400*x_s.x:.2f}")
else:
    print("No optimal solution found")
