
import gurobi

def solve_production_problem():
    # Create a new model
    model = gurobi.Model()

    # Decision variables
    x_n = model.addVar(lb=0, name="North_Factory_Hours")
    x_s = model.addVar(lb=0, name="South_Factory_Hours")

    # Objective function: Minimize cost
    model.setObjective(200 * x_n + 400 * x_s, gurobi.GRB.MINIMIZE)

    # Production constraints
    model.addConstr(20 * x_n + 30 * x_s >= 75, name="Long_Coats")
    model.addConstr(15 * x_n + 25 * x_s >= 30, name="Short_Coats")
    model.addConstr(10 * x_n + 30 * x_s >= 40, name="Mini_Coats")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"North Factory Hours: {x_n.varValue}")
        print(f"South Factory Hours: {x_s.varValue}")
        print(f"Total Cost: {model.objVal}")
    else:
        print("The model is infeasible or unbounded.")

solve_production_problem()
