
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("smoothie_optimization")

# Create variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="apple_smoothies")  # Apple smoothies
y = m.addVar(vtype=GRB.CONTINUOUS, name="orange_smoothies") # Orange smoothies

# Set objective function
m.setObjective(3.5 * x + 4.5 * y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(6 * x + 5 * y <= 500, "cutting_constraint")
m.addConstr(3 * x + 2 * y <= 500, "blending_constraint")
m.addConstr(x >= 0, "apple_nonnegativity")  # Explicit non-negativity constraints
m.addConstr(y >= 0, "orange_nonnegativity")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of apple smoothies (x): {x.x}")
    print(f"Number of orange smoothies (y): {y.x}")
    print(f"Maximum Profit: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {m.status}")

