
from gurobipy import *

# Create a new model
m = Model("Smoothie_Optimization")

# Define the decision variables
A = m.addVar(vtype=GRB.CONTINUOUS, name="Apple_Smoothies", lb=0)
O = m.addVar(vtype=GRB.CONTINUOUS, name="Orange_Smoothies", lb=0)

# Set the objective function
m.setObjective(3.5*A + 4.5*O, GRB.MAXIMIZE)

# Add constraints
m.addConstr(6*A + 5*O <= 500, "Cutting_Machine_Constraint")
m.addConstr(3*A + 2*O <= 500, "Blending_Machine_Constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Apple Smoothies: {A.x}")
    print(f"Orange Smoothies: {O.x}")
    print(f"Total Profit: ${3.5*A.x + 4.5*O.x:.2f}")
else:
    print("No optimal solution found")
